%% example1, holographic imaging of biological sample
% close all
clear all

load('biological_sample.mat')
tdms=ConvertedData.Data.MeasuredData(3).Data;
% figure;plot(tdms);

number=768;
order=256;
cs_rate=[0.015625,0.0625,0.125,0.25,0.5,1];
cs_order=round(sqrt(cs_rate)*order);
kron_number=number/order;
try_nn=1;
start_point2_series=32186;
start_point_series=start_point2_series-36;
sample_image=zeros(number,number,try_nn,length(cs_order));

for try_n=1:try_nn

period=20;
start_point2=start_point2_series(try_n);
start_point=start_point_series(try_n);
nn=60;

co_fitting=zeros(order*order,2);
co_fitting1=zeros(order*order,1);
persuit_basis_fitting=zeros(order*order/64*4+1,1);
persuit_ans=1;
persuit_cyc=1;
count=1;

p=fittype('a0+a1*cos(x*2*pi/20)+b1*sin(x*2*pi/20)+c*x','independent','x','coefficients',{'a0','a1','b1','c'});
opt=fitoptions(p);
opt.StartPoint=[0,0,0,0];

testx=(0:1:start_point2-start_point).';

if persuit_ans==1
    testy=tdms(round(start_point):round(start_point2));
    testy=testy-mean(testy);
    [f,~]=fit(testx,testy,p,opt);
    DC_fitting=(f.a1-1i*f.b1)/2;
    % DC_fitting=f.a1*exp(1i*phi);
    temp_DC_fitting=DC_fitting;
    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
    persuit_cyc=persuit_cyc+1;
    persuit_ans=persuit_ans+1;
    start_point=start_point+nn;
    start_point2=start_point2+nn;
end

testy=tdms(round(start_point):round(start_point2));
testy=testy-mean(testy);
[f,gof]=fit(testx,testy,p,opt);
DC_fitting=(f.a1-1i*f.b1)/2;
% DC_fitting=f.a1*exp(1i*phi);
co_fitting(count,1)=(DC_fitting-temp_DC_fitting/2)*2;
co_fitting1(count,1)=DC_fitting;
co_fitting(count,2)=1-gof.rsquare;

singleimage_intensity2=co_fitting1(count,1)*ones(number);
singleimage_intensity2_pro=co_fitting(count,1)*ones(number);
count=count+1;
if persuit_ans==17
    persuit_ans=1;
else
    persuit_ans=persuit_ans+1;
end
start_point=start_point+nn;
start_point2=start_point2+nn;

for order1=2:order
    for order2=1:order1
        ii=order2;
        jj=order1;
        
        if jj<=order+order*eps
            
            modulation_intensity=zeros(order);
            modulation_intensity(ii,jj)=1;
            modulation_intensity=ifwht(ifwht(modulation_intensity).');
            modulation_intensity=kron(modulation_intensity,ones(kron_number));
            
            if persuit_ans==1
                testy=tdms(round(start_point):round(start_point2));
                testy=testy-mean(testy);
                [f,~]=fit(testx,testy,p,opt);
                DC2_fitting=(f.a1-1i*f.b1)/2;
                temp_DC_fitting=DC2_fitting;
                persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
                persuit_cyc=persuit_cyc+1;
                persuit_ans=persuit_ans+1;
                start_point=start_point+nn;
                start_point2=start_point2+nn;
            end
            testy=tdms(round(start_point):round(start_point2));
            testy=testy-mean(testy);
            [f,gof]=fit(testx,testy,p,opt);
            DC2_fitting=(f.a1-1i*f.b1)/2;
            co_fitting(count,1)=(DC2_fitting-temp_DC_fitting/2)*2;
            co_fitting1(count,1)=DC2_fitting;
            co_fitting(count,2)=1-gof.rsquare;
            
            singleimage_intensity2=singleimage_intensity2+co_fitting1(count,1)*modulation_intensity;
            singleimage_intensity2_pro=singleimage_intensity2_pro+co_fitting(count,1)*modulation_intensity;
            
            count=count+1;
            if persuit_ans==17
                persuit_ans=1;
            else
                persuit_ans=persuit_ans+1;
            end
            start_point=start_point+nn;
            start_point2=start_point2+nn;
            
            fprintf('The loop is %d and gradient is %f\n',count,f.c);
            if abs(ii-jj)>0.5
                
                modulation_intensity=zeros(order);
                modulation_intensity(jj,ii)=1;
                modulation_intensity=ifwht(ifwht(modulation_intensity).');
                modulation_intensity=kron(modulation_intensity,ones(kron_number));
                
                if persuit_ans==1
                    testy=tdms(round(start_point):round(start_point2));
                    testy=testy-mean(testy);
                    [f,~]=fit(testx,testy,p,opt);
                    DC2_fitting=(f.a1-1i*f.b1)/2;
                    temp_DC_fitting=DC2_fitting;
                    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
                    persuit_cyc=persuit_cyc+1;
                    persuit_ans=persuit_ans+1;
                    start_point=start_point+nn;
                    start_point2=start_point2+nn;
                end
                testy=tdms(round(start_point):round(start_point2));
                testy=testy-mean(testy);
                [f,gof]=fit(testx,testy,p,opt);
                DC2_fitting=(f.a1-1i*f.b1)/2;
                co_fitting(count,1)=(DC2_fitting-temp_DC_fitting/2)*2;
                co_fitting1(count,1)=DC2_fitting;
                co_fitting(count,2)=1-gof.rsquare;
                
                singleimage_intensity2=singleimage_intensity2+co_fitting1(count,1)*modulation_intensity;
                singleimage_intensity2_pro=singleimage_intensity2_pro+co_fitting(count,1)*modulation_intensity;
                
                count=count+1;
                if persuit_ans==17
                    persuit_ans=1;
                else
                    persuit_ans=persuit_ans+1;
                end
                start_point=start_point+nn;
                start_point2=start_point2+nn;
                fprintf('The loop is %d and gradient is %f\n',count,f.c);
            end
        end
    end
end
if persuit_ans==1
    testy=tdms(round(start_point):round(start_point2));
    testy=testy-mean(testy);
    [f,~]=fit(testx,testy,p,opt);
    DC2_fitting=(f.a1-1i*f.b1)/2;
%     DC_fitting=f.a1*exp(1i*phi);
    temp_DC_fitting=DC2_fitting;
    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
    persuit_cyc=persuit_cyc+1;
    persuit_ans=persuit_ans+1;
    start_point=start_point+nn;
    start_point2=start_point2+nn;
end

persuit_img_fitting=imag(persuit_basis_fitting);
persuit_rel_fitting=real(persuit_basis_fitting);
persuit_x_fitting=(1:17:17*(length(persuit_basis_fitting)-1)+1).';
real_x_fitting=(1:order*order/16*17).';
[~,loc_x]=ismember(persuit_x_fitting,real_x_fitting);
loc_x(loc_x==0)=[];
real_x_fitting(loc_x)=[];
[smoothfit_img_fitting,~]=smoothfit(persuit_x_fitting,persuit_img_fitting);
close;
[smoothfit_rel_fitting,~]=smoothfit(persuit_x_fitting,persuit_rel_fitting);
close;
real_img_fitting=smoothfit_img_fitting(real_x_fitting);
real_rel_fitting=smoothfit_rel_fitting(real_x_fitting);

co_fitting_ex=(co_fitting1-(real_rel_fitting+1i*real_img_fitting)/2)*2;

ex=1;
cscs=1;
singleimage_intensity2_ex=zeros(number);
for order1=1:order
    if order1==cs_order(cscs)+1
        sample_image(:,:,try_n,cscs)=singleimage_intensity2_ex;
        cscs=cscs+1;
    end
% for order1=1:order-1
    for order2=1:order1
        ii=order2;
        jj=order1;
        if jj<=order+order*eps
            modulation_intensity=zeros(order);
            modulation_intensity(ii,jj)=1;
            modulation_intensity=ifwht(ifwht(modulation_intensity).');
            modulation_intensity=kron(modulation_intensity,ones(kron_number));
            
            singleimage_intensity2_ex=singleimage_intensity2_ex+co_fitting_ex(ex)*modulation_intensity;
            ex=ex+1;
            fprintf('The ex loop is %d\n',ex);
            if abs(ii-jj)>0.5
                modulation_intensity=zeros(order);
                modulation_intensity(jj,ii)=1;
                modulation_intensity=ifwht(ifwht(modulation_intensity).');
                modulation_intensity=kron(modulation_intensity,ones(kron_number));
                
                singleimage_intensity2_ex=singleimage_intensity2_ex+co_fitting_ex(ex)*modulation_intensity;
                ex=ex+1;
                fprintf('The ex loop is %d\n',ex);
            end
        end
    end
end

sample_image(:,:,try_n,cscs)=singleimage_intensity2_ex;
save(['results\co_sample',num2str(try_n),'.mat'],'persuit_basis_fitting','co_fitting','co_fitting1','co_fitting_ex','singleimage_intensity2_ex');

end

save('results\sample_image','sample_image');

%% example2, holographic imaging of background curvature
% close all
clear all

load('background_curvature.mat')
tdms=ConvertedData.Data.MeasuredData(3).Data;
% figure;plot(tdms);

number=768;
order=256;
cs_rate=[0.015625,0.0625,0.125,0.25,0.5,1];
cs_order=round(sqrt(cs_rate)*order);
kron_number=number/order;
try_nn=1;
start_point2_series=670;
start_point_series=start_point2_series-36;
back_image=zeros(number,number,try_nn,length(cs_order));

for try_n=1:try_nn

period=20;
start_point2=start_point2_series(try_n);
start_point=start_point_series(try_n);
nn=60;

co_fitting=zeros(order*order,2);
co_fitting1=zeros(order*order,1);
persuit_basis_fitting=zeros(order*order/32*2+1,1);
persuit_ans=1;
persuit_cyc=1;
count=1;

p=fittype('a0+a1*cos(x*2*pi/20)+b1*sin(x*2*pi/20)+c*x','independent','x','coefficients',{'a0','a1','b1','c'});
opt=fitoptions(p);
opt.StartPoint=[0,0,0,0];

testx=(0:1:start_point2-start_point).';

if persuit_ans==1
    testy=tdms(round(start_point):round(start_point2));
    testy=testy-mean(testy);
    [f,~]=fit(testx,testy,p,opt);
    DC_fitting=(f.a1-1i*f.b1)/2;
    % DC_fitting=f.a1*exp(1i*phi);
    temp_DC_fitting=DC_fitting;
    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
    persuit_cyc=persuit_cyc+1;
    persuit_ans=persuit_ans+1;
    start_point=start_point+nn;
    start_point2=start_point2+nn;
end
testy=tdms(round(start_point):round(start_point2));
testy=testy-mean(testy);
[f,gof]=fit(testx,testy,p,opt);
DC_fitting=(f.a1-1i*f.b1)/2;
% DC_fitting=f.a1*exp(1i*phi);
co_fitting(count,1)=(DC_fitting-temp_DC_fitting/2)*2;
co_fitting1(count,1)=DC_fitting;
co_fitting(count,2)=1-gof.rsquare;

singleimage_intensity2=co_fitting1(count,1)*ones(number);
singleimage_intensity2_pro=co_fitting(count,1)*ones(number);
count=count+1;
if persuit_ans==17
    persuit_ans=1;
else
    persuit_ans=persuit_ans+1;
end
start_point=start_point+nn;
start_point2=start_point2+nn;

for order1=2:order
    for order2=1:order1
        ii=order2;
        jj=order1;
        
        if jj<=order+order*eps
            
            modulation_intensity=zeros(order);
            modulation_intensity(ii,jj)=1;
            modulation_intensity=ifwht(ifwht(modulation_intensity).');
            modulation_intensity=kron(modulation_intensity,ones(kron_number));
            
            if persuit_ans==1
                testy=tdms(round(start_point):round(start_point2));
                testy=testy-mean(testy);
                [f,~]=fit(testx,testy,p,opt);
                DC2_fitting=(f.a1-1i*f.b1)/2;
                temp_DC_fitting=DC2_fitting;
                persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
                persuit_cyc=persuit_cyc+1;
                persuit_ans=persuit_ans+1;
                start_point=start_point+nn;
                start_point2=start_point2+nn;
            end
            testy=tdms(round(start_point):round(start_point2));
            testy=testy-mean(testy);
            [f,gof]=fit(testx,testy,p,opt);
            DC2_fitting=(f.a1-1i*f.b1)/2;
            co_fitting(count,1)=(DC2_fitting-temp_DC_fitting/2)*2;
            co_fitting1(count,1)=DC2_fitting;
            co_fitting(count,2)=1-gof.rsquare;
            
            singleimage_intensity2=singleimage_intensity2+co_fitting1(count,1)*modulation_intensity;
            singleimage_intensity2_pro=singleimage_intensity2_pro+co_fitting(count,1)*modulation_intensity;
                
            count=count+1;
            if persuit_ans==17
                persuit_ans=1;
            else
                persuit_ans=persuit_ans+1;
            end
            start_point=start_point+nn;
            start_point2=start_point2+nn;
            
            fprintf('The loop is %d and gradient is %f\n',count,f.c);
            if abs(ii-jj)>0.5
                
                modulation_intensity=zeros(order);
                modulation_intensity(jj,ii)=1;
                modulation_intensity=ifwht(ifwht(modulation_intensity).');
                modulation_intensity=kron(modulation_intensity,ones(kron_number));
                
                if persuit_ans==1
                    testy=tdms(round(start_point):round(start_point2));
                    testy=testy-mean(testy);
                    [f,~]=fit(testx,testy,p,opt);
                    DC2_fitting=(f.a1-1i*f.b1)/2;
                    temp_DC_fitting=DC2_fitting;
                    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
                    persuit_cyc=persuit_cyc+1;
                    persuit_ans=persuit_ans+1;
                    start_point=start_point+nn;
                    start_point2=start_point2+nn;
                end
                testy=tdms(round(start_point):round(start_point2));
                testy=testy-mean(testy);
                [f,gof]=fit(testx,testy,p,opt);
                DC2_fitting=(f.a1-1i*f.b1)/2;
                co_fitting(count,1)=(DC2_fitting-temp_DC_fitting/2)*2;
                co_fitting1(count,1)=DC2_fitting;
                co_fitting(count,2)=1-gof.rsquare;
                
                singleimage_intensity2=singleimage_intensity2+co_fitting1(count,1)*modulation_intensity;
                singleimage_intensity2_pro=singleimage_intensity2_pro+co_fitting(count,1)*modulation_intensity;
                
                count=count+1;
                if persuit_ans==17
                    persuit_ans=1;
                else
                    persuit_ans=persuit_ans+1;
                end
                start_point=start_point+nn;
                start_point2=start_point2+nn;
                fprintf('The loop is %d and gradient is %f\n',count,f.c);
            end
        end
    end
end
if persuit_ans==1
    testy=tdms(round(start_point):round(start_point2));
    testy=testy-mean(testy);
    [f,~]=fit(testx,testy,p,opt);
    DC2_fitting=(f.a1-1i*f.b1)/2;
%     DC_fitting=f.a1*exp(1i*phi);
    temp_DC_fitting=DC2_fitting;
    persuit_basis_fitting(persuit_cyc,1)=temp_DC_fitting;
    persuit_cyc=persuit_cyc+1;
    persuit_ans=persuit_ans+1;
    start_point=start_point+nn;
    start_point2=start_point2+nn;
end

persuit_img_fitting=imag(persuit_basis_fitting);
persuit_rel_fitting=real(persuit_basis_fitting);
persuit_x_fitting=(1:17:17*(length(persuit_basis_fitting)-1)+1).';
real_x_fitting=(1:order*order/16*17).';
[~,loc_x]=ismember(persuit_x_fitting,real_x_fitting);
loc_x(loc_x==0)=[];
real_x_fitting(loc_x)=[];
[smoothfit_img_fitting,~]=smoothfit(persuit_x_fitting,persuit_img_fitting);
close;
[smoothfit_rel_fitting,~]=smoothfit(persuit_x_fitting,persuit_rel_fitting);
close;
real_img_fitting=smoothfit_img_fitting(real_x_fitting);
real_rel_fitting=smoothfit_rel_fitting(real_x_fitting);

co_fitting_ex=(co_fitting1-(real_rel_fitting+1i*real_img_fitting)/2)*2;

ex=1;
cscs=1;
singleimage_intensity2_ex=zeros(number);
for order1=1:order
    if order1==cs_order(cscs)+1
        back_image(:,:,try_n,cscs)=singleimage_intensity2_ex;
        cscs=cscs+1;
    end
% for order1=1:order-1
    for order2=1:order1
        ii=order2;
        jj=order1;
        if jj<=order+order*eps
            modulation_intensity=zeros(order);
            modulation_intensity(ii,jj)=1;
            modulation_intensity=ifwht(ifwht(modulation_intensity).');
            modulation_intensity=kron(modulation_intensity,ones(kron_number));
            
            singleimage_intensity2_ex=singleimage_intensity2_ex+co_fitting_ex(ex)*modulation_intensity;
            ex=ex+1;
            fprintf('The ex loop is %d\n',ex);
            if abs(ii-jj)>0.5
                modulation_intensity=zeros(order);
                modulation_intensity(jj,ii)=1;
                modulation_intensity=ifwht(ifwht(modulation_intensity).');
                modulation_intensity=kron(modulation_intensity,ones(kron_number));
                
                singleimage_intensity2_ex=singleimage_intensity2_ex+co_fitting_ex(ex)*modulation_intensity;
                ex=ex+1;
                fprintf('The ex loop is %d\n',ex);
            end
        end
    end
end
back_image(:,:,try_n,cscs)=singleimage_intensity2_ex;

save(['results\co_back',num2str(try_n),'.mat'],'co_fitting','co_fitting1','co_fitting_ex','singleimage_intensity2_ex');

end

save('results\back_image','back_image');

%% formal-amplitude 100%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:3:end,13:3:end,try_n,6));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(125:129,125:129)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(size(original_image_nor,1)/2+1,[1:100,154:252])=mean_fff;
    fff_amp([1:99,155:252],size(original_image_nor,1)/2+1)=mean_fff;
    fff_amp(125:129,[62:66,189:193])=mean_fff;
    fff_amp([61:69,185:193],126:128)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=8 %2:3:11 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex(iter_image_f_ex>0.6)=mean(mean(iter_image_f_ex));
iter_image_f_ex=kron(iter_image_f_ex,ones(3));
figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);title('amplitude imaging');

saveas(gca,'results\imaging-amplitude.fig');

%% formal-phase 100%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1 %1:4 %
    final_image=sample_image(:,:,try_n,6).*exp(-1i*angle(back_image(:,:,try_n,6)));
    final_image1=final_image(13:3:end,13:3:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    %     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
    for sigma=10 %2:3:8 %
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-2*pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi;
    end
end
complex=exp(1i*iter_image_f);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(3));
figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);title('phase imaging');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

saveas(gca,'results\imaging-phase.fig');

%%
figure;
%% formal-amplitude 3.125%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:12:end,13:12:end,try_n,1));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(30:34,30:34)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(32,[2:4,61:63])=mean_fff;
    fff_amp([1:24,40:63],32)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=6 %3:3:12 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex=kron(iter_image_f_ex,ones(12));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,5);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('amplitude, CS=3.125%');

%% formal-phase 3.125%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1:1 %1:4 %
    final_image=sample_image(:,:,try_n,1).*exp(-1i*angle(back_image(:,:,try_n,1)));
    final_image1=final_image(13:12:end,13:12:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    for sigma=1 %10:5:50
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi/2;
    end
end
complex=exp(1i*iter_image_f);
complex=complex*exp(1i);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(12));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,10);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('phase, CS=3.125%');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

%% formal-amplitude 6.25%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:12:end,13:12:end,try_n,2));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(30:34,30:34)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(32,[1:2,62:63])=mean_fff;
    fff_amp([1:2,62:63],32)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=9 %6:3:12 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex=kron(iter_image_f_ex,ones(12));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,4);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('amplitude, CS=6.25%');

%% formal-phase 6.25%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1 %1:4 %
    final_image=sample_image(:,:,try_n,2).*exp(-1i*angle(back_image(:,:,try_n,2)));
    final_image1=final_image(13:12:end,13:12:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    for sigma=5 %1:2:7 %
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi/2;
    end
end
complex=exp(1i*iter_image_f);
complex=complex*exp(1.1i);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(12));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,9);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('phase, CS=6.25%');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

%% formal-amplitude 12.5%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:6:end,13:6:end,try_n,3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(62:66,62:66)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(size(original_image_nor,1)/2+1,[1:35,93:126])=mean_fff;
    fff_amp([1:35,93:126],size(original_image_nor,1)/2+1)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=12 %8:3:14 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex=kron(iter_image_f_ex,ones(6));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,3);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('amplitude, CS=12.5%');

%% formal-phase 12.5%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1 %1:4 %
    final_image=sample_image(:,:,try_n,3).*exp(-1i*angle(back_image(:,:,try_n,3)));
    final_image1=final_image(13:6:end,13:6:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    for sigma=4 %2:2:6 %
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-2*pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi;
    end
end
complex=exp(1i*iter_image_f);
complex=complex*exp(1.8i);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(6));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,8);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('phase, CS=12.5%');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

%% formal-amplitude 25%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:6:end,13:6:end,try_n,4));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(62:66,62:66)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(size(original_image_nor,1)/2+1,[1:35,93:126])=mean_fff;
    fff_amp([1:35,93:126],size(original_image_nor,1)/2+1)=mean_fff;
    fff_amp([1:4,124:126],63:65)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=10 %4:3:13 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex=kron(iter_image_f_ex,ones(6));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,2);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('amplitude, CS=25%');

%% formal-phase 25%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1 %1:4 %
    final_image=sample_image(:,:,try_n,4).*exp(-1i*angle(back_image(:,:,try_n,4)));
    final_image1=final_image(13:6:end,13:6:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    for sigma=5 %2:2:8 %
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-2*pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi;
    end
end
complex=exp(1i*iter_image_f);
% complex=complex*exp(-2.1i);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(6));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,7);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('phase, CS=25%');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

%% formal-amplitude 50%CS
clear all
load('results\sample_image.mat');

for try_n=1 %1:4 %
    original_image=abs(sample_image(13:3:end,13:3:end,try_n,5));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
%     original_image_nor=SB_ATV(original_image_nor,20);
    fff=fftshift(fft2(ifftshift(original_image_nor)))/sqrt(size(original_image_nor,1));
    fff_phase=angle(fff);
    fff_amp=abs(fff);
%     fff_amp(125:129,125:129)=0;figure;surf(fff_amp);shading interp;axis off;view(0,90);
    mean_fff=mean(mean(fff_amp));
    fff_amp(size(original_image_nor,1)/2+1,[31:100,154:223])=mean_fff;
    fff_amp([29:109,145:225],size(original_image_nor,1)/2+1)=mean_fff;
    fff_amp(126:128,[62:68,187:193])=mean_fff;
    fff_amp([61:69,185:193],126:128)=mean_fff;
    fff=fff_amp.*exp(1i*fff_phase);
    original_image_nor=abs(fftshift(ifft2(ifftshift(fff)))/sqrt(size(original_image_nor,1)));
    original_image_nor=255*(original_image_nor-min(original_image_nor(:)))/(max(original_image_nor(:))-min(original_image_nor(:)));
%     figure;surf(original_image_nor);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);
%================================================%
    for sigma=13 %5:5:15 %
            sigma_f=sqrt(sigma);
            iter_image=original_image_nor;
            [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
            iter_image_f(:,:,try_n)=(temp-min(temp(:)))/(max(temp(:))-min(temp(:)));
    end
end
iter_image_f_ex=iter_image_f;
iter_image_f_ex=kron(iter_image_f_ex,ones(3));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,150,540,800]);
subplot(2,5,1);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('amplitude, CS=50%');

%% formal-phase 50%CS
clear all
load('results\sample_image.mat');
load('results\back_image.mat');

for try_n=1 %1:4 %
    final_image=sample_image(:,:,try_n,5).*exp(-1i*angle(back_image(:,:,try_n,5)));
    final_image1=final_image(13:3:end,13:3:end);
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1:end,1))*exp(-1i*angle(mean(final_image1(1:end,end)))))+2*pi)/(size(final_image1,2)-1)*kron(linspace(0,size(final_image1,2)-1,size(final_image1,2)),ones(size(final_image1,1),1)));
    final_image1=final_image1.*exp(1i*(angle(mean(final_image1(1,1:end))*exp(-1i*angle(mean(final_image1(end,1:end))))))/(size(final_image1,1)-1)*kron(linspace(0,size(final_image1,1)-1,size(final_image1,1)).',ones(1,size(final_image1,2))));
    original_image=angle(final_image1*exp(1i*pi/4*3));
    original_image_nor=255*(original_image-min(original_image(:)))/(max(original_image(:))-min(original_image(:)));
    for sigma=7 %2:3:11 %
        sigma_f=sqrt(sigma);
        iter_image=original_image_nor;
        [~,temp]=BM3D(1,iter_image/255,sigma_f^2);
        iter_image_f(:,:,try_n)=-2*pi*(temp-min(temp(:)))/(max(temp(:))-min(temp(:)))+pi;
    end
end
complex=exp(1i*iter_image_f);
% complex=complex*exp(-2i);
iter_image_f_ex=angle(complex);
iter_image_f_ex=kron(iter_image_f_ex,ones(3));
% figure;surf(iter_image_f_ex);shading interp;axis off;view(45,-90);set(gcf,'position',[640,280,224,317]);% set(gcf,'position',[640,280,336,476]);% set(gcf,'position',[640,250,540,620]);
subplot(2,5,6);surf(iter_image_f_ex);shading interp;axis off;view(45,-90);title('phase, CS=50%');

ax = gca;
set(gca,'Clim',[-pi,pi]);
mcolor=load('mcolor2.mat');
mcolor=mcolor.mcolor2;
colormap(ax,mcolor);

%% save holographic imaging figure with CS
set(gcf,'Position',get(0,'ScreenSize'));
saveas(gca,'results\imaging with compressive sensing.fig');